/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedspaces.parentchild;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="document/parentChildOnNestedSpaces")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode
extends org.xwiki.index.tree.internal.nestedpages.DocumentTreeNode {
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    protected List<DocumentReference> getChildDocuments(DocumentReference documentReference, int offset, int limit) throws QueryException {
        Query query = this.getChildDocumentsQuery(documentReference);
        query.setOffset(offset);
        query.setLimit(limit);
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
        for (Object result : query.execute()) {
            documentReferences.add(this.explicitDocumentReferenceResolver.resolve((Object)((String)result), new Object[]{documentReference}));
        }
        return documentReferences;
    }

    private Query getChildDocumentsQuery(DocumentReference documentReference) throws QueryException {
        Query query = this.queryManager.createQuery("where doc.translation = 0 and doc.space = :space and doc.parent in (:absoluteRef, :localRef, :relativeRef) order by lower(doc.name), doc.name", "hql");
        query.bindValue("space", this.localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]));
        query.bindValue("absoluteRef", this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]));
        query.bindValue("localRef", this.localEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]));
        query.bindValue("relativeRef", this.compactEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[]{documentReference.getParent()}));
        query.setWiki(documentReference.getWikiReference().getName());
        if (Boolean.TRUE.equals(this.getProperties().get("filterHiddenDocuments"))) {
            query.addFilter((QueryFilter)this.hiddenDocumentQueryFilterProvider.get());
        }
        return query;
    }

    @Override
    protected int getChildDocumentsCount(DocumentReference documentReference) throws QueryException {
        Query query = this.getChildDocumentsQuery(documentReference);
        query.addFilter(this.countQueryFilter);
        return ((Long)query.execute().get(0)).intValue();
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        DocumentReference parentReference = document.getParentReference();
        if (parentReference != null && parentReference.getParent().equals((Object)documentReference.getParent())) {
            return parentReference;
        }
        return documentReference.getParent();
    }
}

