/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.managers.ListenerManager;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.BotData;
import org.xwiki.ircbot.internal.BotListenerData;
import org.xwiki.ircbot.wiki.WikiIRCBotConstants;
import org.xwiki.ircbot.wiki.WikiIRCBotListenerManager;
import org.xwiki.ircbot.wiki.WikiIRCBotManager;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;

@Component
@Singleton
public class DefaultWikiIRCBotManager
implements WikiIRCBotManager,
WikiIRCBotConstants {
    @Inject
    @Named(value="wiki")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private IRCBot bot;
    @Inject
    private WikiIRCModel ircModel;
    @Inject
    private Provider<List<IRCBotListener>> botListenerComponents;
    @Inject
    private WikiIRCBotListenerManager botListenerManager;
    @Inject
    private ModelContext modelContext;

    @Override
    public void startBot(boolean updateBotStatus) throws IRCBotException {
        if (this.isBotStarted()) {
            throw new IRCBotException("Bot is already started!");
        }
        this.initializeBot();
        BotData botData = this.ircModel.loadBotData();
        if (botData.isActive() || updateBotStatus) {
            ListenerManager<? extends PircBotX> listenerManager = this.bot.getListenerManager();
            for (IRCBotListener botListener : (List)this.botListenerComponents.get()) {
                listenerManager.addListener((Listener)botListener);
            }
            this.botListenerManager.registerWikiBotListeners();
            if (!this.bot.isConnected()) {
                this.bot.setName(botData.getName());
                try {
                    this.bot.connect(botData.getServer());
                }
                catch (Exception e) {
                    throw new IRCBotException(String.format("Failed to connect to IRC server [%s]", botData.getServer()), e);
                }
                if (!StringUtils.isEmpty((CharSequence)botData.getPassword())) {
                    this.bot.identify(botData.getPassword());
                }
            }
            this.bot.joinChannel(botData.getChannel());
            if (updateBotStatus && !botData.isActive()) {
                this.ircModel.setActive(true);
            }
        }
    }

    @Override
    public void stopBot(boolean updateBotStatus) throws IRCBotException {
        if (!this.isBotStarted()) {
            throw new IRCBotException("Bot is already stopped!");
        }
        this.bot.disconnect();
        while (this.bot.isConnected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IRCBotException("Failed to fully wait for IRC client termination", e);
            }
        }
        this.botListenerManager.unregisterWikiBotListeners();
        if (updateBotStatus) {
            this.ircModel.setActive(false);
        }
    }

    @Override
    public boolean isBotStarted() {
        return this.bot.isConnected();
    }

    @Override
    public List<BotListenerData> getBotListenerData() throws IRCBotException {
        HashMap<String, BotListenerData> data = new HashMap<String, BotListenerData>();
        for (BotListenerData listenerData : this.ircModel.getWikiBotListenerData()) {
            data.put(listenerData.getId(), listenerData);
        }
        try {
            Map botListeners = this.componentManager.getInstanceMap(IRCBotListener.class);
            for (Map.Entry entry : botListeners.entrySet()) {
                BotListenerData listenerData = new BotListenerData((String)entry.getKey(), ((IRCBotListener)entry.getValue()).getName(), ((IRCBotListener)entry.getValue()).getDescription());
                if (data.containsKey(entry.getKey())) continue;
                data.put((String)entry.getKey(), listenerData);
            }
        }
        catch (ComponentLookupException e) {
            throw new IRCBotException("Failed to lookup IRC Bot Listeners", e);
        }
        return new ArrayList<BotListenerData>(data.values());
    }

    @Override
    public Map<String, Object> getContext() throws IRCBotException {
        return (Map)this.ircModel.getXWikiContext().get((Object)"irclistener");
    }

    private synchronized void initializeBot() {
        this.bot.initialize(this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName());
    }
}

