/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.ircbot.DocumentModifiedEventListenerConfiguration;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultDocumentModifiedEventListenerConfiguration
implements DocumentModifiedEventListenerConfiguration {
    private static final String PATTERN_PROPERTY = "pattern";
    private static final EntityReference CONFIGURATION_CLASS = new EntityReference("DocumentModifiedClass", EntityType.DOCUMENT, new EntityReference("IRC", EntityType.SPACE));
    @Inject
    private WikiIRCModel ircModel;

    @Override
    public List<Pattern> getExclusionPatterns() throws IRCBotException {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        XWikiDocument configurationDocument = this.ircModel.getConfigurationDocument();
        List exclusionObjects = configurationDocument.getXObjects(CONFIGURATION_CLASS);
        if (exclusionObjects != null) {
            for (BaseObject exclusionObject : exclusionObjects) {
                String pattern = exclusionObject.getStringValue(PATTERN_PROPERTY);
                patterns.add(Pattern.compile(pattern));
            }
        }
        return patterns;
    }
}

