/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ircxarimport")
@Singleton
public class XARImportEventListener
implements EventListener {
    public static final String XAR_IMPORT_COUNTER_KEY = "ircxarcounter";
    @Inject
    private IRCBot bot;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentAccessBridge dab;
    @Inject
    private ModelContext modelContext;
    @Inject
    private Execution execution;

    public List<Event> getEvents() {
        return Arrays.asList(new XARImportingEvent(), new XARImportedEvent());
    }

    public String getName() {
        return "ircxarimport";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.bot.isConnected()) {
            try {
                String message;
                ExecutionContext ec = this.execution.getContext();
                if (event instanceof XARImportingEvent) {
                    ec.setProperty(XAR_IMPORT_COUNTER_KEY, (Object)0L);
                    message = String.format("A XAR import has been started by %s in wiki %s", this.getNotificationAuthor(), this.getNotificationWiki());
                } else {
                    long counter = (Long)ec.getProperty(XAR_IMPORT_COUNTER_KEY);
                    ec.removeProperty(XAR_IMPORT_COUNTER_KEY);
                    message = String.format("The XAR import started by %s in wiki %s is now finished, %d documents have been imported", this.getNotificationAuthor(), this.getNotificationWiki(), counter);
                }
                this.bot.sendMessage(this.bot.getChannelsNames().iterator().next(), message);
            }
            catch (IRCBotException e) {
                this.logger.error("Failed to handle event [{}] for source [{}]", new Object[]{event, source, e});
            }
        }
    }

    private String getNotificationAuthor() throws IRCBotException {
        return (String)this.serializer.serialize((EntityReference)this.dab.getCurrentUserReference(), new Object[0]);
    }

    private String getNotificationWiki() throws IRCBotException {
        EntityReference reference = this.modelContext.getCurrentEntityReference();
        if (reference == null) {
            throw new IRCBotException("The current wiki couldn't be computed");
        }
        return reference.extractReference(EntityType.WIKI).getName();
    }
}

