/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import org.apache.commons.lang3.StringUtils;
import org.pircbotx.hooks.Event;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.macro.MacroErrorManager;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

public class DefaultExecutor
implements WikiIRCModel.Executor {
    private Transformation macroTransformation;
    private BlockRenderer plainTextBlockRenderer;
    private MacroErrorManager macroErrorManager = new MacroErrorManager();
    private XDOM xdom;
    private Syntax syntax;
    private Event event;

    public DefaultExecutor(XDOM xdom, Syntax syntax, Event event, Transformation macroTransformation, BlockRenderer plainTextBlockRenderer) {
        this.xdom = xdom;
        this.syntax = syntax;
        this.event = event;
        this.macroTransformation = macroTransformation;
        this.plainTextBlockRenderer = plainTextBlockRenderer;
    }

    @Override
    public void execute() throws Exception {
        String result = this.renderContent(this.xdom, this.syntax);
        if (!StringUtils.isEmpty((CharSequence)result) && this.event != null) {
            this.event.respond(result);
        }
    }

    private String renderContent(XDOM xdom, Syntax syntax) throws TransformationException, IRCBotException {
        XDOM temporaryXDOM = xdom.clone();
        TransformationContext txContext = new TransformationContext(temporaryXDOM, syntax);
        this.macroTransformation.transform((Block)temporaryXDOM, txContext);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextBlockRenderer.render((Block)temporaryXDOM, (WikiPrinter)printer);
        if (this.macroErrorManager.containsError(temporaryXDOM)) {
            throw new IRCBotException(String.format("Macro error when rendering Wiki Bot Listener content [%s]", printer.toString()));
        }
        return StringUtils.trim((String)printer.toString());
    }
}

