/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.internal.BotData;
import org.xwiki.ircbot.internal.BotListenerData;
import org.xwiki.ircbot.wiki.WikiIRCBotConstants;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultWikiIRCModel
implements WikiIRCModel,
WikiIRCBotConstants {
    private static final String SECURITY_DOC_PROPERTY = "sdoc";
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceSerializer<String> defaultSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private EntityReferenceValueProvider defaultEntityReferenceValueProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    private IRCBot bot;

    @Override
    public XWikiDocument getDocument(DocumentReference reference) throws IRCBotException {
        XWikiDocument doc;
        XWikiContext xwikiContext = this.getXWikiContext();
        try {
            doc = xwikiContext.getWiki().getDocument(reference, xwikiContext);
        }
        catch (XWikiException e) {
            throw new IRCBotException(String.format("Unable to load document [%s]", reference), e);
        }
        return doc;
    }

    @Override
    public XWikiDocument getConfigurationDocument() throws IRCBotException {
        XWikiDocument document = this.getDocument(new DocumentReference(this.bot.getWikiId(), "IRC", "IRCConfiguration"));
        if (document.isNew()) {
            document = this.getDocument(new DocumentReference(this.defaultEntityReferenceValueProvider.getDefaultValue(EntityType.WIKI), "IRC", "IRCConfiguration"));
        }
        return document;
    }

    @Override
    public XWikiContext getXWikiContext() throws IRCBotException {
        XWikiContext xwikiContext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
        if (xwikiContext == null) {
            throw new IRCBotException("The XWiki Context is not available in the Execution Context");
        }
        return xwikiContext;
    }

    @Override
    public BotData loadBotData() throws IRCBotException {
        BaseObject configurationObject = this.getIRCConfigurationObject();
        BotData botData = new BotData(configurationObject.getStringValue("botname"), configurationObject.getStringValue("server"), configurationObject.getStringValue("password"), configurationObject.getStringValue("channel"), configurationObject.getIntValue("inactive") != 1);
        return botData;
    }

    @Override
    public void setActive(boolean isActive) throws IRCBotException {
        this.getIRCConfigurationObject().set("inactive", (Object)(isActive ? 0 : 1), this.getXWikiContext());
    }

    @Override
    public List<BotListenerData> getWikiBotListenerData() throws IRCBotException {
        List results;
        try {
            Query query = this.queryManager.createQuery(String.format("select distinct doc.space, doc.name, listener.name, listener.description from Document doc, doc.object(%s) as listener", this.defaultSerializer.serialize(WIKI_BOT_LISTENER_CLASS, new Object[0])), "xwql");
            results = query.execute();
        }
        catch (QueryException e) {
            throw new IRCBotException("Failed to locate IRC Bot listener objects in the wiki", e);
        }
        ArrayList<BotListenerData> data = new ArrayList<BotListenerData>();
        for (Object[] documentData : results) {
            EntityReference relativeReference = new EntityReference((String)documentData[1], EntityType.DOCUMENT, new EntityReference((String)documentData[0], EntityType.SPACE));
            data.add(new BotListenerData((String)this.compactWikiSerializer.serialize(relativeReference, new Object[0]), (String)documentData[2], (String)documentData[3], true));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsUser(DocumentReference executingUserReference, DocumentReference securityDocumentReference, WikiIRCModel.Executor executor) throws Exception {
        XWikiContext xwikiContext = this.getXWikiContext();
        DocumentReference currentUserReference = xwikiContext.getUserReference();
        XWikiDocument currentSecurityDocument = (XWikiDocument)xwikiContext.get((Object)SECURITY_DOC_PROPERTY);
        try {
            xwikiContext.setUserReference(executingUserReference);
            xwikiContext.put((Object)SECURITY_DOC_PROPERTY, (Object)this.getDocument(securityDocumentReference));
            executor.execute();
        }
        finally {
            xwikiContext.setUserReference(currentUserReference);
            if (currentSecurityDocument != null) {
                xwikiContext.put((Object)SECURITY_DOC_PROPERTY, (Object)currentSecurityDocument);
            } else {
                xwikiContext.remove((Object)SECURITY_DOC_PROPERTY);
            }
        }
    }

    private BaseObject getIRCConfigurationObject() throws IRCBotException {
        XWikiDocument configurationDocument = this.getConfigurationDocument();
        BaseObject configurationObject = configurationDocument.getXObject(WIKI_BOT_CONFIGURATION_CLASS);
        if (configurationObject == null) {
            throw new IRCBotException(String.format("Cannot find the IRC Configuration object in the [%s] document", configurationDocument.getDocumentReference()));
        }
        return configurationObject;
    }
}

