/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.wiki.script;

import com.xpn.xwiki.XWikiContext;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.BotListenerData;
import org.xwiki.ircbot.wiki.WikiIRCBotManager;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="ircbot")
@Singleton
public class WikiIRCBotScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.ircbot.error";
    private static final String RIGHTS_REQUIRED = "This action requires to be logged on the main wiki and to have Admin rights there.";
    @Inject
    private WikiIRCBotManager wikiBotManager;
    @Inject
    @Named(value="wiki")
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceValueProvider valueProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private WikiIRCModel ircModel;
    @Inject
    private Execution execution;

    public void start(boolean updateBotStatus) {
        if (this.hasPermission()) {
            try {
                this.wikiBotManager.startBot(updateBotStatus);
            }
            catch (IRCBotException e) {
                this.setError(e);
            }
        } else {
            this.setError(new IRCBotException(RIGHTS_REQUIRED));
        }
    }

    public void stop(boolean updateBotStatus) {
        if (this.hasPermission()) {
            try {
                this.wikiBotManager.stopBot(updateBotStatus);
            }
            catch (IRCBotException e) {
                this.setError(e);
            }
        } else {
            this.setError(new IRCBotException(RIGHTS_REQUIRED));
        }
    }

    public boolean isStarted() {
        return this.wikiBotManager.isBotStarted();
    }

    public Map<BotListenerData, Boolean> getBotListenerStatuses() {
        HashMap<BotListenerData, Boolean> statuses = new HashMap<BotListenerData, Boolean>();
        try {
            for (BotListenerData listenerData : this.wikiBotManager.getBotListenerData()) {
                statuses.put(listenerData, this.componentManager.hasComponent(IRCBotListener.class, listenerData.getId()));
            }
        }
        catch (IRCBotException e) {
            statuses = null;
        }
        return statuses;
    }

    public Map<String, Object> getContext() {
        Map<String, Object> context;
        try {
            context = this.wikiBotManager.getContext();
        }
        catch (IRCBotException e) {
            context = null;
        }
        return context;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    private void setError(Exception exception) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)exception);
    }

    public boolean hasPermission() {
        boolean hasPermission = false;
        try {
            XWikiContext context = this.ircModel.getXWikiContext();
            DocumentReference userReference = context.getUserReference();
            if (userReference != null) {
                String mainWiki = this.valueProvider.getDefaultValue(EntityType.WIKI);
                if (userReference.getWikiReference().getName().equals(mainWiki)) {
                    DocumentReference mainXWikiPreferencesReference = new DocumentReference(mainWiki, "XWiki", "XWikiPreferences");
                    hasPermission = context.getWiki().getRightService().hasAccessLevel("admin", (String)this.entityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]), (String)this.entityReferenceSerializer.serialize((EntityReference)mainXWikiPreferencesReference, new Object[0]), context);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasPermission;
    }
}

