/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.handler.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.handler.internal.JobResourceReferenceHandler;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.annotations.Authenticate;
import org.xwiki.url.internal.ParentResourceReference;

@Component
@Named(value="job")
@Singleton
@Authenticate
public class JobRootResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    public static final String HINT = "job";
    public static final ResourceType TYPE = new ResourceType("job");
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private ModelContext modelContext;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(TYPE);
    }

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        ParentResourceReference reference = (ParentResourceReference)resourceReference;
        if ("wiki".equals(reference.getChild()) && !reference.getPathSegments().isEmpty()) {
            String wiki = (String)reference.getPathSegments().get(0);
            this.modelContext.setCurrentEntityReference((EntityReference)new WikiReference(wiki));
            String child = reference.getPathSegments().size() > 1 ? (String)reference.getPathSegments().get(1) : "";
            List pathSegments = reference.getPathSegments();
            pathSegments = pathSegments.size() > 2 ? pathSegments.subList(2, pathSegments.size()) : Collections.emptyList();
            this.handleChild(new ParentResourceReference(reference.getType(), reference.getRootPath(), child, pathSegments));
        } else {
            this.handleChild(reference);
        }
        chain.handleNext((ResourceReference)reference);
    }

    private void handleChild(ParentResourceReference reference) throws ResourceReferenceHandlerException {
        if (StringUtils.isNotEmpty((CharSequence)reference.getChild())) {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            if (componentManager.hasComponent(JobResourceReferenceHandler.class, reference.getChild())) {
                JobResourceReferenceHandler child;
                try {
                    child = (JobResourceReferenceHandler)componentManager.getInstance(JobResourceReferenceHandler.class, reference.getChild());
                }
                catch (ComponentLookupException e) {
                    throw new ResourceReferenceHandlerException("Failed to initialize job resource handler with hint [" + reference.getChild() + "]");
                }
                child.handle(reference);
            } else {
                throw new ResourceReferenceHandlerException("Unknow job resource handler with hint [" + reference.getChild() + "]");
            }
        }
    }
}

