/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.script;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.script.internal.safe.ScriptSafeProvider;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="job")
@Singleton
public class JobScriptService
implements ScriptService {
    public static final String JOB_ERROR_KEY = "scriptservice.job.error";
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private JobStatusStore jobStore;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private ScriptSafeProvider scriptSafeProvider;
    @Inject
    private Execution execution;

    public JobStatus getJobStatus(List<String> jobId) {
        Job job = this.jobExecutor.getJob(jobId);
        JobStatus jobStatus = job == null ? this.jobStore.getJobStatus(jobId) : job.getStatus();
        if (jobStatus != null && !this.authorization.hasAccess(Right.PROGRAM)) {
            jobStatus = this.safe(jobStatus);
        }
        return jobStatus;
    }

    public Job getJob(List<String> jobId) throws AccessDeniedException {
        this.authorization.checkAccess(Right.PROGRAM);
        return this.jobExecutor.getJob(jobId);
    }

    public Job getCurrentJob(Collection<String> path) {
        this.setError(null);
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            return this.jobExecutor.getCurrentJob(new JobGroupPath(path));
        }
        this.setError((Exception)new JobException("You need programming rights to get the current job."));
        return null;
    }

    public JobStatus getCurrentJobStatus(Collection<String> path) {
        Job job = this.jobExecutor.getCurrentJob(new JobGroupPath(path));
        JobStatus jobStatus = null;
        if (job != null) {
            jobStatus = job.getStatus();
            if (!this.authorization.hasAccess(Right.PROGRAM)) {
                jobStatus = this.safe(jobStatus);
            }
        }
        return jobStatus;
    }

    protected <T> T safe(T unsafe) {
        return (T)this.scriptSafeProvider.get(unsafe);
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(JOB_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(JOB_ERROR_KEY, (Object)e);
    }
}

