/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.jodatime;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.jodatime.JodaTimePluginApi;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JodaTimePlugin
extends XWikiDefaultPlugin {
    public JodaTimePlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public String getName() {
        return "jodatime";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new JodaTimePluginApi((JodaTimePlugin)plugin, context);
    }

    public void init(XWikiContext context) {
        super.init(context);
    }

    public DateTime getDateTime() {
        return new DateTime();
    }

    public DateTime getDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public DateTime getDateTime(long instant) {
        return new DateTime(instant);
    }

    public MutableDateTime getMutableDateTime() {
        return new MutableDateTime();
    }

    public MutableDateTime getMutableDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new MutableDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public MutableDateTime getMutableDateTime(long instant) {
        return new MutableDateTime(instant);
    }

    public DateTimeFormatter getDateTimeFormatterForPattern(String pattern, XWikiContext context) {
        return DateTimeFormat.forPattern((String)pattern).withLocale((Locale)context.get((Object)"locale"));
    }

    public DateTimeFormatter getDateTimeFormatterForStyle(String style, XWikiContext context) {
        return DateTimeFormat.forStyle((String)style).withLocale((Locale)context.get((Object)"locale"));
    }

    public DateTimeZone getServerTimezone() {
        return DateTimeZone.getDefault();
    }

    public DateTimeZone getUTCTimezone() {
        return DateTimeZone.UTC;
    }

    public DateTimeZone getTimezone(String locationOrOffset) {
        return DateTimeZone.forID((String)locationOrOffset);
    }

    public DateTimeZone getTimezone(int offsetHours) {
        return DateTimeZone.forOffsetHours((int)offsetHours);
    }

    public DateTimeZone getTimezone(int offsetHours, int offsetMinutes) {
        return DateTimeZone.forOffsetHoursMinutes((int)offsetHours, (int)offsetMinutes);
    }
}

