/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.model.internal.reference;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

/**
 * Same as DefaultStringEntityReferenceResolver but with the extended type in the role hint instead of the role type.
 * 
 * @version $Id: df4edd1e1a6a6ee33062b892e94e6bc55dbc8f12 $
 * @since 2.2M1
 * @deprecated use {@link DefaultStringEntityReferenceResolver} instead.
 */
@Component
@Singleton
@Deprecated
public class DeprecatedDefaultStringEntityReferenceResolver implements EntityReferenceResolver
{
    @Inject
    private EntityReferenceResolver<String> resolver;

    @Override
    public EntityReference resolve(Object entityReferenceRepresentation, EntityType type, Object... parameters)
    {
        return this.resolver.resolve((String) entityReferenceRepresentation, type, parameters);
    }
}
