/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.lesscss.internal.cache.CacheKeyFactory;
import org.xwiki.lesscss.internal.cache.LESSCache;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReference;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.resources.LESSResourceReference;

public abstract class AbstractCache<T>
implements LESSCache<T> {
    @Inject
    protected CacheManager cacheManager;
    protected boolean isContextHandled = true;
    protected Cache<T> cache;
    private Map<Object, List<String>> cachedFilesKeysMapPerSkin = new HashMap<Object, List<String>>();
    private Map<Object, List<String>> cachedFilesKeysMapPerColorTheme = new HashMap<Object, List<String>>();
    private Map<Object, List<String>> cachedFilesKeysMapPerLESSResource = new HashMap<Object, List<String>>();
    @Inject
    private CacheKeyFactory cacheKeyFactory;
    private Map<String, String> mutexList = new HashMap<String, String>();

    public T get(LESSResourceReference lessResourceReference, SkinReference skin, ColorThemeReference colorTheme) {
        return (T)this.cache.get(this.cacheKeyFactory.getCacheKey(lessResourceReference, skin, colorTheme, this.isContextHandled));
    }

    public void set(LESSResourceReference lessResourceReference, SkinReference skin, ColorThemeReference colorTheme, T content) {
        String cacheKey = this.cacheKeyFactory.getCacheKey(lessResourceReference, skin, colorTheme, this.isContextHandled);
        this.cache.set(cacheKey, content);
        this.registerCacheKey(this.cachedFilesKeysMapPerSkin, cacheKey, skin);
        this.registerCacheKey(this.cachedFilesKeysMapPerColorTheme, cacheKey, colorTheme);
        this.registerCacheKey(this.cachedFilesKeysMapPerLESSResource, cacheKey, lessResourceReference);
    }

    private void registerCacheKey(Map<Object, List<String>> cachedFilesKeysMap, String cacheKey, Object reference) {
        List<String> cachedFilesKeys = cachedFilesKeysMap.get(reference);
        if (cachedFilesKeys == null) {
            cachedFilesKeys = new ArrayList<String>();
            cachedFilesKeysMap.put(reference, cachedFilesKeys);
        }
        if (!cachedFilesKeys.contains(cacheKey)) {
            cachedFilesKeys.add(cacheKey);
        }
    }

    public void clear() {
        this.cache.removeAll();
        this.cachedFilesKeysMapPerSkin.clear();
        this.cachedFilesKeysMapPerColorTheme.clear();
        this.cachedFilesKeysMapPerLESSResource.clear();
    }

    private void clearFromCriteria(Map<Object, List<String>> cachedFilesKeysMap, Object criteria) {
        List<String> cachedFilesKeys = cachedFilesKeysMap.get(criteria);
        if (cachedFilesKeys == null) {
            return;
        }
        for (String cachedFileKey : cachedFilesKeys) {
            this.cache.remove(cachedFileKey);
        }
        cachedFilesKeysMap.remove(criteria);
    }

    public void clearFromSkin(SkinReference skin) {
        this.clearFromCriteria(this.cachedFilesKeysMapPerSkin, skin);
    }

    public void clearFromColorTheme(ColorThemeReference colorTheme) {
        this.clearFromCriteria(this.cachedFilesKeysMapPerColorTheme, colorTheme);
    }

    public void clearFromLESSResource(LESSResourceReference lessResourceReference) {
        this.clearFromCriteria(this.cachedFilesKeysMapPerLESSResource, lessResourceReference);
    }

    public synchronized Object getMutex(LESSResourceReference lessResourceReference, SkinReference skin, ColorThemeReference colorTheme) {
        String cacheKey = this.cacheKeyFactory.getCacheKey(lessResourceReference, skin, colorTheme, this.isContextHandled);
        String mutex = this.mutexList.get(cacheKey);
        if (mutex == null) {
            mutex = cacheKey;
            this.mutexList.put(cacheKey, mutex);
        }
        return mutex;
    }
}

