/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import com.github.sommeri.less4j.Less4jException;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.io.StringWriter;
import java.util.concurrent.Semaphore;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.LESSConfiguration;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.compiler.less4j.Less4jCompiler;
import org.xwiki.lesscss.internal.resources.LESSSkinFileResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReference;

@Component(roles={CachedLESSCompiler.class})
@Singleton
public class CachedLESSCompiler
implements CachedCompilerInterface<String>,
Initializable {
    public static final String MAIN_SKIN_STYLE_FILENAME = "style.less.vm";
    private static final String SKIN_CONTEXT_KEY = "skin";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Less4jCompiler less4JCompiler;
    @Inject
    private LESSConfiguration lessConfiguration;
    private Semaphore semaphore;

    public void initialize() throws InitializationException {
        this.semaphore = new Semaphore(this.lessConfiguration.getMaximumSimultaneousCompilations(), true);
    }

    @Override
    public String compute(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean useLESS, String skin) throws LESSCompilerException {
        StringWriter source = new StringWriter();
        try {
            this.semaphore.acquire();
            if (lessResourceReference instanceof LESSSkinFileResourceReference || includeSkinStyle) {
                if (includeSkinStyle) {
                    source.write(String.format("@import (reference) \"%s\";%s", MAIN_SKIN_STYLE_FILENAME, System.lineSeparator()));
                }
                source.write(lessResourceReference.getContent(skin));
            }
            String lessCode = source.toString();
            if (useVelocity) {
                lessCode = this.executeVelocity(lessCode, skin);
            }
            if (useLESS) {
                String string = this.less4JCompiler.compile(lessCode, skin, this.lessConfiguration.isGenerateInlineSourceMaps());
                return string;
            }
            String string = lessCode;
            return string;
        }
        catch (Less4jException | InterruptedException e) {
            throw new LESSCompilerException(String.format("Failed to compile the resource [%s] with LESS.", lessResourceReference), (Exception)e);
        }
        finally {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeVelocity(String source, String skin) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentSkin = xwiki.getSkin(xcontext);
        try {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)skin);
            }
            String string = xwiki.evaluateVelocity(source, xcontext.getDoc().getPrefixedFullName());
            return string;
        }
        finally {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)currentSkin);
            }
        }
    }
}

