/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.skin.SkinManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

public class LESSSkinFileResourceReference
implements LESSResourceReference {
    private String fileName;
    private TemplateManager templateManager;
    private SkinManager skinManager;

    public LESSSkinFileResourceReference(String fileName, TemplateManager templateManager, SkinManager skinManager) {
        this.fileName = fileName;
        this.templateManager = templateManager;
        this.skinManager = skinManager;
    }

    public boolean equals(Object o) {
        if (o instanceof LESSSkinFileResourceReference) {
            return this.fileName.equals(((LESSSkinFileResourceReference)o).fileName);
        }
        return false;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public String getContent(String skin) throws LESSCompilerException {
        Template template = this.templateManager.getTemplate("less/" + this.fileName, this.skinManager.getSkin(skin));
        if (template == null) {
            throw new LESSCompilerException(String.format("The template [%s] does not exists.", this.fileName));
        }
        try {
            return template.getContent().getContent();
        }
        catch (Exception e) {
            throw new LESSCompilerException(String.format("Failed to get the content of the template [%s].", this.fileName), e);
        }
    }

    public String serialize() {
        return String.format("LessSkinFile[%s]", this.fileName);
    }

    public String toString() {
        return this.serialize();
    }
}

