/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component(roles={LESSContext.class})
@Singleton
public class LESSContext {
    private static final String CACHE_PROPERTY = "less.cache.disable";
    private static final String HTML_EXPORT = "less.htmlexport";
    @Inject
    private Execution execution;

    public void disableCache() {
        this.setProperty(CACHE_PROPERTY, true);
    }

    public void stopDisablingCache() {
        this.setProperty(CACHE_PROPERTY, false);
    }

    public boolean isCacheDisabled() {
        return Boolean.TRUE.equals(this.getContext().getProperty(CACHE_PROPERTY));
    }

    public void setHtmlExport(boolean htmlExport) {
        this.setProperty(HTML_EXPORT, htmlExport);
    }

    public boolean isHtmlExport() {
        return Boolean.TRUE.equals(this.getContext().getProperty(HTML_EXPORT));
    }

    private ExecutionContext getContext() {
        return this.execution.getContext();
    }

    private void setProperty(String propertyName, Object value) {
        Object property = this.getContext().getProperty(propertyName);
        if (property != null) {
            this.getContext().setProperty(propertyName, value);
        } else {
            this.getContext().newProperty(propertyName).inherited().initial(value).declare();
        }
    }
}

