/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.internal.cache.XWikiContextCacheKeyFactory;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReference;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.resources.LESSResourceReference;

@Component(roles={CacheKeyFactory.class})
@Singleton
public class CacheKeyFactory {
    private static final String CACHE_KEY_SEPARATOR = "_";
    @Inject
    private XWikiContextCacheKeyFactory xcontextCacheKeyFactory;

    public String getCacheKey(LESSResourceReference lessResourceReference, SkinReference skinReference, ColorThemeReference colorThemeReference, boolean withContext) {
        String lessResource = lessResourceReference.serialize();
        String skin = skinReference.serialize();
        String colorTheme = colorThemeReference.serialize();
        String result = lessResource.length() + CACHE_KEY_SEPARATOR + lessResource + CACHE_KEY_SEPARATOR + skin.length() + CACHE_KEY_SEPARATOR + skin + CACHE_KEY_SEPARATOR + colorTheme.length() + CACHE_KEY_SEPARATOR + colorTheme;
        if (withContext) {
            String xcontext = this.xcontextCacheKeyFactory.getCacheKey();
            result = result + CACHE_KEY_SEPARATOR + xcontext.length() + CACHE_KEY_SEPARATOR + xcontext;
        }
        return result;
    }
}

