/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.AbstractCachedCompiler;
import org.xwiki.lesscss.internal.cache.LESSResourcesCache;
import org.xwiki.lesscss.internal.compiler.CachedLESSCompiler;
import org.xwiki.lesscss.resources.LESSResourceReference;

@Component
@Singleton
public class DefaultLESSCompiler
extends AbstractCachedCompiler<String>
implements LESSCompiler,
Initializable {
    @Inject
    private LESSResourcesCache cache;
    @Inject
    private CachedLESSCompiler cachedLESSCompiler;

    public void initialize() throws InitializationException {
        ((AbstractCachedCompiler)this).cache = this.cache;
        this.compiler = this.cachedLESSCompiler;
    }

    public String compile(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean force) throws LESSCompilerException {
        return (String)super.getResult(lessResourceReference, includeSkinStyle, useVelocity, force);
    }

    public String compile(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, String skin, boolean force) throws LESSCompilerException {
        return (String)super.getResult(lessResourceReference, includeSkinStyle, useVelocity, skin, force);
    }

    @Override
    protected String cloneResult(String toClone) {
        return new String(toClone);
    }

    @Override
    protected String exceptionAsResult(LESSCompilerException exception) {
        StringWriter serializedException = new StringWriter();
        exception.printStackTrace(new PrintWriter(serializedException));
        return String.format("/* %s */", serializedException.toString());
    }
}

