/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.colortheme.ColorThemeReference;
import org.xwiki.lesscss.colortheme.ColorThemeReferenceSerializer;
import org.xwiki.lesscss.colortheme.DocumentColorThemeReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="org.xwiki.lesscss.colortheme.DocumentColorThemeReference")
@Singleton
public class DocumentColorThemeReferenceSerializer
implements ColorThemeReferenceSerializer {
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Logger logger;

    public String serialize(ColorThemeReference colorThemeReference) {
        if (!(colorThemeReference instanceof DocumentColorThemeReference)) {
            this.logger.warn("Invalid LESS resource type [{}].", (Object)colorThemeReference.toString());
            return null;
        }
        DocumentColorThemeReference docColorThemeRef = (DocumentColorThemeReference)colorThemeReference;
        return String.format("ColorThemeDocument[%s]", this.entityReferenceSerializer.serialize((EntityReference)docColorThemeRef.getColorThemeDocument(), new Object[0]));
    }
}

