/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.compiler.SkinDirectoryGetter;
import org.xwiki.lesscss.resources.LESSResourceReader;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSSkinFileResourceReference;

@Component(roles={CachedIntegratedLESSCompiler.class})
@Singleton
public class CachedIntegratedLESSCompiler
implements CachedCompilerInterface<String> {
    private static final String SKIN_CONTEXT_KEY = "skin";
    private static final String MAIN_SKIN_STYLE_FILENAME = "style.less.vm";
    private static final String LESS_INCLUDE_SEPARATOR = ".realStartOfXWikiSSX{color:#000}";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private LESSCompiler lessCompiler;
    @Inject
    private SkinDirectoryGetter skinDirectoryGetter;
    @Inject
    private LESSResourceReader lessResourceReader;

    @Override
    public String compute(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, String skin) throws LESSCompilerException {
        StringWriter source = new StringWriter();
        ArrayList<Path> includePaths = new ArrayList<Path>();
        ArrayList<File> tempFilesToDelete = new ArrayList<File>();
        File tempDir = null;
        try {
            if (lessResourceReference instanceof LESSSkinFileResourceReference || includeSkinStyle) {
                tempDir = this.createTempDir(includePaths, tempFilesToDelete);
                Path lessFilesPath = this.skinDirectoryGetter.getLESSSkinFilesDirectory(skin);
                includePaths.add(lessFilesPath);
                if (includeSkinStyle) {
                    this.importMainSkinStyle(source, skin, tempDir, tempFilesToDelete);
                }
                source.write(this.lessResourceReader.getContent(lessResourceReference, skin));
            }
            String lessCode = source.toString();
            if (useVelocity) {
                lessCode = this.executeVelocity(source.toString(), skin);
            }
            Path[] includePathsArray = includePaths.toArray(new Path[1]);
            String result = this.lessCompiler.compile(lessCode, includePathsArray);
            if (includeSkinStyle) {
                result = this.removeMainSkinStyleUndesiredOutput(result);
            }
            String string = result;
            return string;
        }
        catch (IOException | LESSCompilerException e) {
            throw new LESSCompilerException(String.format("Failed to compile the resource [%s] with LESS.", lessResourceReference), (Exception)e);
        }
        finally {
            this.deleteTempFiles(tempFilesToDelete);
        }
    }

    private File createTempDir(List<Path> includePaths, List<File> tempFilesToDelete) throws IOException {
        File tempDir = Files.createTempDirectory("XWikiLESSCompilation", new FileAttribute[0]).toFile();
        includePaths.add(tempDir.toPath());
        tempFilesToDelete.add(tempDir);
        tempDir.deleteOnExit();
        return tempDir;
    }

    private void importMainSkinStyle(StringWriter source, String skin, File tempDir, List<File> tempFilesToDelete) throws LESSCompilerException, IOException {
        String mainSkinStyle = this.lessResourceReader.getContent((LESSResourceReference)new LESSSkinFileResourceReference(MAIN_SKIN_STYLE_FILENAME), skin);
        String velocityOutput = this.executeVelocity(mainSkinStyle, skin);
        File mainSkinStyleFile = new File(tempDir, MAIN_SKIN_STYLE_FILENAME);
        FileWriter fileWriter = new FileWriter(mainSkinStyleFile);
        IOUtils.copy((Reader)new StringReader(velocityOutput), (Writer)fileWriter);
        fileWriter.close();
        tempFilesToDelete.add(mainSkinStyleFile);
        mainSkinStyleFile.deleteOnExit();
        source.write("@import (reference) \"style.less.vm\";\n");
        source.write(LESS_INCLUDE_SEPARATOR);
    }

    private String removeMainSkinStyleUndesiredOutput(String cssCode) {
        int contentToRemoveIndex = cssCode.indexOf(LESS_INCLUDE_SEPARATOR) + LESS_INCLUDE_SEPARATOR.length();
        return cssCode.substring(contentToRemoveIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeVelocity(String source, String skin) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentSkin = xwiki.getSkin(xcontext);
        try {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)skin);
            }
            String string = xwiki.parseContent(source, xcontext);
            return string;
        }
        finally {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)currentSkin);
            }
        }
    }

    private void deleteTempFiles(List<File> tempFilesToDelete) {
        for (int i = tempFilesToDelete.size() - 1; i >= 0; --i) {
            File tempFile = tempFilesToDelete.get(i);
            tempFile.delete();
        }
        tempFilesToDelete.clear();
    }
}

