/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={SkinDirectoryGetter.class})
@Singleton
public class SkinDirectoryGetter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public String getSkinDirectory(String skin) throws LESSCompilerException {
        return "/skins/" + this.getSkinDirectory(skin, new ArrayList<String>());
    }

    private String getSkinDirectory(String skin, List<String> alreadyVisitedSkins) throws LESSCompilerException {
        if (alreadyVisitedSkins.contains(skin)) {
            throw new LESSCompilerException(String.format("Infinite loop of 'baseskin' dependencies [%s].", alreadyVisitedSkins.toString()), null);
        }
        alreadyVisitedSkins.add(skin);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference skinDocRef = this.documentReferenceResolver.resolve((Object)skin, new Object[]{new WikiReference(currentWikiId)});
        if (skinDocRef != null && xwiki.exists(skinDocRef, xcontext)) {
            DocumentReference skinClass = new DocumentReference(skinDocRef.getWikiReference().getName(), "XWiki", "XWikiSkins");
            try {
                XWikiDocument skinDoc = xwiki.getDocument(skinDocRef, xcontext);
                BaseObject skinObj = skinDoc.getXObject(skinClass);
                if (skinObj != null) {
                    String baseSkin = skinObj.getStringValue("baseskin");
                    if (StringUtils.isBlank((String)baseSkin)) {
                        throw new LESSCompilerException(String.format("Failed to get the base skin of the skin [%s].", skin), null);
                    }
                    return this.getSkinDirectory(baseSkin, alreadyVisitedSkins);
                }
            }
            catch (XWikiException e) {
                throw new LESSCompilerException(String.format("Failed to get the document [%s].", skinDocRef), (Exception)((Object)e));
            }
        }
        return skin;
    }

    public Path getLESSSkinFilesDirectory(String skin) throws LESSCompilerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String path = this.getSkinDirectory(skin) + "/less";
        String realPath = xwiki.getEngineContext().getRealPath(path);
        File lessDirectory = new File(realPath);
        if (!lessDirectory.exists() || !lessDirectory.isDirectory()) {
            throw new LESSCompilerException(String.format("The path [%s] is not a directory or does not exists.", path));
        }
        return Paths.get(realPath, new String[0]);
    }
}

