/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReferenceSerializer;

@Component
@Singleton
public class DefaultLESSResourceReferenceSerializer
implements LESSResourceReferenceSerializer {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String serialize(LESSResourceReference lessResourceReference) {
        try {
            LESSResourceReferenceSerializer serializer = (LESSResourceReferenceSerializer)this.componentManager.getInstance(LESSResourceReferenceSerializer.class, lessResourceReference.getClass().getName());
            return serializer.serialize(lessResourceReference);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("The LESS Resource Reference [{}] is not handled by the compiler.", (Object)lessResourceReference, (Object)e);
            return null;
        }
    }
}

