/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.skin;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.lesscss.skin.SkinReference;
import org.xwiki.lesscss.skin.SkinReferenceSerializer;

@Component
@Singleton
public class DefaultSkinReferenceSerializer
implements SkinReferenceSerializer {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String serialize(SkinReference skinReference) {
        try {
            SkinReferenceSerializer serializer = (SkinReferenceSerializer)this.componentManager.getInstance(SkinReferenceSerializer.class, skinReference.getClass().getName());
            return serializer.serialize(skinReference);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("The skin type [{}] is not handled by the LESS Module.", (Object)skinReference, (Object)e);
            return null;
        }
    }
}

