/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.linkchecker.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.transformation.linkchecker.LinkStateManager;

@Component
@Named(value="linkchecker")
@Singleton
public class LinkCheckerEventListener
implements EventListener {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private LinkStateManager linkStateManager;

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentUpdatingEvent());
    }

    public String getName() {
        return "LinkChecker";
    }

    public void onEvent(Event event, Object source, Object data) {
        DocumentModelBridge doc = (DocumentModelBridge)source;
        String reference = (String)this.serializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]);
        Map states = this.linkStateManager.getLinkStates();
        for (Map.Entry entry : states.entrySet()) {
            Map state = (Map)entry.getValue();
            state.remove(reference);
            if (state.size() != 0) continue;
            states.remove(entry.getKey());
        }
    }
}

