/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.internal.AbstractCachedTranslationBundle;
import org.xwiki.localization.internal.DefaultLocalizedTranslationBundle;
import org.xwiki.localization.internal.DefaultTranslation;
import org.xwiki.localization.internal.LocalizedBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.localization.message.TranslationMessageParser;

public abstract class AbstractResourceTranslationBundle
extends AbstractCachedTranslationBundle {
    public static final String ID_PREFIX = "resource:";
    @Inject
    protected TranslationBundleContext bundleContext;
    protected String baseName;
    protected ClassLoader classloader;

    public AbstractResourceTranslationBundle(String baseName) {
        super(ID_PREFIX + baseName);
        this.baseName = baseName;
    }

    public AbstractResourceTranslationBundle(String baseName, ClassLoader classloader) {
        this(baseName);
        this.classloader = classloader;
    }

    protected abstract TranslationMessageParser getTranslationMessageParser();

    @Override
    protected LocalizedBundle createBundle(Locale locale) {
        DefaultLocalizedTranslationBundle localeBundle;
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(this.baseName, locale, this.classloader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        if (bundle != null) {
            localeBundle = new DefaultLocalizedTranslationBundle(this, locale);
            TranslationMessageParser parser = this.getTranslationMessageParser();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String message = bundle.getString(key);
                TranslationMessage translationMessage = parser.parse(message);
                localeBundle.addTranslation(new DefaultTranslation(this.bundleContext, localeBundle, key, translationMessage));
            }
        } else {
            localeBundle = null;
        }
        return localeBundle;
    }
}

