/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.TranslationBundleDoesNotExistsException;
import org.xwiki.localization.TranslationBundleFactory;
import org.xwiki.localization.TranslationBundleFactoryDoesNotExistsException;

@Component
public class DefaultLocalizationManager
implements LocalizationManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private TranslationBundleContext bundleContext;
    @Inject
    private Logger logger;

    @Override
    public Translation getTranslation(String key, Locale locale) {
        for (TranslationBundle bundle : this.bundleContext.getBundles()) {
            Translation translation = bundle.getTranslation(key, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    @Override
    public void use(String bundleType, String bundleId) throws TranslationBundleDoesNotExistsException, TranslationBundleFactoryDoesNotExistsException {
        TranslationBundleFactory bundleFactory;
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent(TranslationBundle.class, bundleType + ':' + bundleId)) {
            try {
                this.bundleContext.addBundle((TranslationBundle)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundle.class, bundleType + ':' + bundleId));
                return;
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup translation bundle with hint [{}] and type [{}].", new Object[]{bundleId, bundleType, e});
            }
        }
        try {
            bundleFactory = (TranslationBundleFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundleFactory.class, bundleType);
        }
        catch (ComponentLookupException e) {
            throw new TranslationBundleFactoryDoesNotExistsException(String.format("Failed to lookup BundleFactory for type [%s]", bundleType), e);
        }
        TranslationBundle bundle = bundleFactory.getBundle(bundleId);
        this.bundleContext.addBundle(bundle);
    }
}

