/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.localization;

import java.util.Collection;

import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

/**
 * The Bundles applying to the current context ordered by priority.
 * 
 * @version $Id: 8c49c4a2424a2d2402ff875d9da0846b80adcf9b $
 * @since 4.3M2
 */
@Role
@Unstable
public interface TranslationBundleContext
{
    /**
     * @return the bundles applying to the current context ordered by priority
     */
    Collection<TranslationBundle> getBundles();

    /**
     * Add a new bundle to the collection. It will be automatically ordered.
     * 
     * @param bundle the bundle
     */
    void addBundle(TranslationBundle bundle);
}
