/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.script;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="localization")
@Singleton
public class LocalizationScriptService
implements ScriptService {
    @Inject
    private LocalizationManager localization;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;

    public Translation get(String key) {
        return this.localization.getTranslation(key, this.localizationContext.getCurrentLocale());
    }

    public boolean use(String bundleType, String bundleId) {
        try {
            this.localization.use(bundleType, bundleId);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Locale getCurrentLocale() {
        return this.localizationContext.getCurrentLocale();
    }

    public Locale toLocale(String str) {
        try {
            return LocaleUtils.toLocale((String)str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String render(String key) {
        return this.render(key, Collections.EMPTY_LIST);
    }

    public String render(String key, Collection<?> parameters) {
        return this.render(key, Syntax.PLAIN_1_0, parameters);
    }

    public String render(String key, Syntax syntax) {
        return this.render(key, syntax, Collections.EMPTY_LIST);
    }

    public String render(String key, Syntax syntax, Collection<?> parameters) {
        String result = null;
        Locale currentLocale = this.localizationContext.getCurrentLocale();
        Translation translation = this.localization.getTranslation(key, currentLocale);
        if (translation != null) {
            Block block = translation.render(currentLocale, parameters.toArray());
            try {
                BlockRenderer renderer = (BlockRenderer)((ComponentManager)this.componentManager.get()).getInstance(BlockRenderer.class, syntax.toIdString());
                DefaultWikiPrinter wikiPrinter = new DefaultWikiPrinter();
                renderer.render(block, (WikiPrinter)wikiPrinter);
                result = wikiPrinter.toString();
            }
            catch (ComponentLookupException e) {
                block = null;
            }
        } else {
            result = key;
        }
        return result;
    }
}

