/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.jar.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.jar.internal.JARFileTranslationBundle;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="localization.bundle.JARTranslationBundleFactoryListener")
@Singleton
public class JARTranslationBundleFactoryListener
implements EventListener,
Initializable {
    protected static final String NAME = "localization.bundle.JARTranslationBundleFactoryListener";
    private static final String EXTENSION_TYPE = "jar";
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent());
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    @Named(value="messagetool/1.0")
    private TranslationMessageParser translationParser;
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private Logger logger;

    public void onEvent(Event event, Object source, Object data) {
        ExtensionEvent extensionEvent = (ExtensionEvent)event;
        InstalledExtension extension = (InstalledExtension)source;
        if (EXTENSION_TYPE.equals(extension.getType())) {
            if (event instanceof ExtensionInstalledEvent) {
                this.extensionAdded(extension, extensionEvent.getNamespace());
            } else if (event instanceof ExtensionUninstalledEvent) {
                this.extensionDeleted(extension, extensionEvent.getNamespace());
            } else {
                this.extensionUpgraded(extension, (Collection)data, extensionEvent.getNamespace());
            }
        }
    }

    public String getName() {
        return "localization.bundle.JARTranslationBundleFactory";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void initialize() throws InitializationException {
        for (InstalledExtension extension : this.installedRepository.getInstalledExtensions()) {
            if (!EXTENSION_TYPE.equals(extension.getType())) continue;
            if (extension.isInstalled(null)) {
                this.extensionAdded(extension, null);
                continue;
            }
            for (String namespace : extension.getNamespaces()) {
                this.extensionAdded(extension, namespace);
            }
        }
    }

    private ComponentDescriptor<TranslationBundle> createComponentDescriptor(URL jarURL) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setImplementation(JARFileTranslationBundle.class);
        descriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        descriptor.setRoleHint("jar:" + jarURL);
        descriptor.setRoleType(TranslationBundle.class);
        return descriptor;
    }

    private ComponentDescriptor<TranslationBundle> createComponentDescriptor(InstalledExtension extension) throws MalformedURLException {
        File jarFile = new File(extension.getFile().getAbsolutePath());
        return this.createComponentDescriptor(jarFile.toURI().toURL());
    }

    private void extensionUpgraded(InstalledExtension newExtension, Collection<InstalledExtension> previousExtensions, String namespace) {
        for (InstalledExtension previousExtension : previousExtensions) {
            this.extensionDeleted(previousExtension, namespace);
        }
        this.extensionAdded(newExtension, namespace);
    }

    private void extensionDeleted(InstalledExtension extension, String namespace) {
        try {
            ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(extension);
            ComponentManager componentManager = this.componentManagerManager.getComponentManager(namespace, false);
            componentManager.unregisterComponent(descriptor);
        }
        catch (Exception e) {
            this.logger.error("Failed to create TranslationBundle descriptor for extension [{}]", (Object)extension, (Object)e);
        }
    }

    private void extensionAdded(InstalledExtension extension, String namespace) {
        try {
            File jarFile = new File(extension.getFile().getAbsolutePath());
            ComponentManager componentManager = this.componentManagerManager.getComponentManager(namespace, false);
            if (componentManager == null) {
                componentManager = this.rootComponentManager;
            }
            JARFileTranslationBundle bundle = new JARFileTranslationBundle(jarFile, componentManager, this.translationParser);
            ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(jarFile.toURI().toURL());
            componentManager.registerComponent(descriptor, (Object)bundle);
        }
        catch (Exception e) {
            this.logger.error("Failed to register a TranslationBundle component for extension [{}] on namespace [{}]", new Object[]{extension, namespace, e});
        }
    }
}

