/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.jar.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleDoesNotExistsException;
import org.xwiki.localization.TranslationBundleFactory;

@Component
@Named(value="jar")
@Singleton
public class JARTranslationBundleFactory
implements TranslationBundleFactory {
    public static final String ID = "jar";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private Logger logger;

    public TranslationBundle getBundle(String bundleId) throws TranslationBundleDoesNotExistsException {
        String id = "jar:" + bundleId;
        if (((ComponentManager)this.contextComponentManagerProvider.get()).hasComponent(TranslationBundle.class, id)) {
            try {
                return (TranslationBundle)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(TranslationBundle.class, id);
            }
            catch (ComponentLookupException e) {
                this.logger.debug("Failed to lookup component [{}] with hint [{}].", new Object[]{TranslationBundle.class, bundleId, e});
            }
        }
        throw new TranslationBundleDoesNotExistsException(String.format("Can't find any JAR resource for jar [%s]", bundleId));
    }
}

