/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.legacy.internal.xwikipreferences;

import com.xpn.xwiki.internal.event.XObjectPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.Translation;
import org.xwiki.localization.internal.AbstractTranslationBundle;
import org.xwiki.localization.legacy.internal.xwikipreferences.XWikiPreferencesTranslationBundle;
import org.xwiki.localization.wiki.internal.DefaultDocumentTranslationBundle;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public class XWikiPreferencesWikiTranslationBundle
extends AbstractTranslationBundle
implements EventListener,
DisposableCacheValue {
    public static final String ID = "XWikiPreferences.wiki";
    private static final String DOCUMENT_BUNDLE_PROPERTY = "documentBundles";
    private static final String JOIN_SEPARATOR = ",";
    private ObservationManager observation;
    private DocumentAccessBridge documentAccessBridge;
    private DocumentReferenceResolver<String> resolver;
    private final List<Event> events;
    private final String wiki;
    private XWikiPreferencesTranslationBundle parent;
    private Map<DocumentReference, DefaultDocumentTranslationBundle> bundles;

    public XWikiPreferencesWikiTranslationBundle(String wiki, XWikiPreferencesTranslationBundle parent, ComponentManager componentManager) throws ComponentLookupException {
        super("XWikiPreferences.wiki." + wiki);
        this.wiki = wiki;
        this.parent = parent;
        this.observation = (ObservationManager)componentManager.getInstance(ObservationManager.class);
        this.documentAccessBridge = (DocumentAccessBridge)componentManager.getInstance(DocumentAccessBridge.class);
        this.resolver = (DocumentReferenceResolver)componentManager.getInstance((Type)DocumentReferenceResolver.TYPE_STRING);
        this.intializeBundles();
        DocumentReference preferences = new DocumentReference(this.wiki, "XWiki", "XWikiPreferences");
        EntityReference documentBundlesProperty = new EntityReference(DOCUMENT_BUNDLE_PROPERTY, EntityType.OBJECT_PROPERTY, (EntityReference)new RegexEntityReference(Pattern.compile(this.wiki + ":XWiki.XWikiPreferences\\[\\d*\\]"), EntityType.OBJECT, (EntityReference)preferences));
        this.events = Arrays.asList(new XObjectPropertyAddedEvent(documentBundlesProperty), new XObjectPropertyUpdatedEvent(documentBundlesProperty));
        this.observation.addListener((EventListener)this);
    }

    private Set<DocumentReference> getDocuments() {
        Set<DocumentReference> documents;
        DocumentReference preferencesReference = new DocumentReference(this.wiki, "XWiki", "XWikiPreferences");
        String documentNameListString = (String)this.documentAccessBridge.getProperty(preferencesReference, preferencesReference, DOCUMENT_BUNDLE_PROPERTY);
        if (documentNameListString != null) {
            String[] documentNameList = documentNameListString.split(JOIN_SEPARATOR);
            documents = new LinkedHashSet<DocumentReference>(documentNameList.length);
            for (String documentName : documentNameList) {
                documents.add(this.resolver.resolve((Object)documentName.trim(), new Object[]{preferencesReference}));
            }
        } else {
            documents = Collections.emptySet();
        }
        return documents;
    }

    private void intializeBundles() {
        Set<DocumentReference> documents = this.getDocuments();
        LinkedHashMap<DocumentReference, DefaultDocumentTranslationBundle> newBundles = new LinkedHashMap<DocumentReference, DefaultDocumentTranslationBundle>(documents.size());
        for (DocumentReference document : documents) {
            newBundles.put(document, this.parent.getDocumentTranslationBundle(document));
        }
        this.bundles = newBundles;
    }

    public String getName() {
        return "localization.bundle." + this.getId();
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void onEvent(Event arg0, Object arg1, Object arg2) {
        this.intializeBundles();
    }

    public Translation getTranslation(String key, Locale locale) {
        for (DefaultDocumentTranslationBundle bundle : this.bundles.values()) {
            Translation translation = bundle.getTranslation(key, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    public void dispose() throws Exception {
        this.observation.removeListener(this.getName());
    }
}

