/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LoggerManager;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="logging")
@Singleton
public class LoggingScriptService
implements ScriptService {
    @Inject
    private LoggerManager loggerManager;
    @Inject
    private DocumentAccessBridge bridge;

    public Map<String, LogLevel> getLevels() {
        Collection loggers = this.loggerManager.getLoggers();
        HashMap<String, LogLevel> levels = new HashMap<String, LogLevel>(loggers.size());
        for (Logger logger : loggers) {
            levels.put(logger.getName(), this.getLevel(logger.getName()));
        }
        return levels;
    }

    public LogLevel getLevel(String loggerName) {
        return this.loggerManager.getLoggerLevel(loggerName);
    }

    public void setLevel(String logger, LogLevel level) {
        if (!this.bridge.hasProgrammingRights()) {
            return;
        }
        this.loggerManager.setLoggerLevel(logger, level);
    }
}

