/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogTree;
import org.xwiki.logging.LogUtils;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="logging")
@Singleton
public class LoggingScriptService
implements ScriptService {
    @Inject
    private LoggerManager loggerManager;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private ContextualLocalizationManager localization;

    public Map<String, LogLevel> getLevels() {
        Collection loggers = this.loggerManager.getLoggers();
        HashMap<String, LogLevel> levels = new HashMap<String, LogLevel>(loggers.size());
        for (Logger logger : loggers) {
            levels.put(logger.getName(), this.getLevel(logger.getName()));
        }
        return levels;
    }

    public LogLevel getLevel(String loggerName) {
        return this.loggerManager.getLoggerLevel(loggerName);
    }

    public void setLevel(String logger, LogLevel level) {
        if (!this.bridge.hasProgrammingRights()) {
            return;
        }
        this.loggerManager.setLoggerLevel(logger, level);
    }

    public LogTree toLogTree(Iterable<LogEvent> logs) {
        LogTree logTree = new LogTree();
        for (LogEvent logEvent : logs) {
            logTree.log(logEvent);
        }
        return logTree;
    }

    public LogEvent translate(LogEvent logEvent) {
        Translation translation;
        if (logEvent.getTranslationKey() != null && (translation = this.localization.getTranslation(logEvent.getTranslationKey())) != null) {
            return LogUtils.translate((LogEvent)logEvent, (String)((String)translation.getRawSource()));
        }
        return logEvent;
    }
}

