/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class AddressesConverter
extends AbstractConverter<Address[]> {
    protected Address[] convertToType(Type targetType, Object value) {
        InternetAddress[] addresses;
        if (value == null) {
            return null;
        }
        if (value instanceof Address[]) {
            return (Address[])value;
        }
        try {
            addresses = InternetAddress.parse((String)value.toString());
        }
        catch (AddressException e) {
            throw new ConversionException(String.format("Failed to convert [%s] to an array of [%s]", value, Address.class.getName()), (Throwable)e);
        }
        return addresses;
    }

    protected String convertToString(Address[] value) {
        return InternetAddress.toString((Address[])value);
    }
}

