/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailResult;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.internal.DefaultMailResult;
import org.xwiki.mail.internal.thread.MailQueueManager;
import org.xwiki.mail.internal.thread.PrepareMailQueueItem;
import org.xwiki.mail.internal.thread.context.Copier;

@Component
@Singleton
public class DefaultMailSender
implements MailSender {
    private static final String SESSION_BATCHID_KEY = "xwiki.batchId";
    private static final int TIMEOUT = 60;
    @Inject
    private Execution execution;
    @Inject
    private MailQueueManager<PrepareMailQueueItem> prepareMailQueueManager;
    @Inject
    private Copier<ExecutionContext> executionContextCloner;

    public MailResult sendAsynchronously(Iterable<? extends MimeMessage> messages, Session session, MailListener listener) {
        ExecutionContext executionContext;
        ExecutionContext clonedExecutionContext;
        XWikiContext xcontext;
        String batchId = session.getProperty(SESSION_BATCHID_KEY);
        if (batchId == null) {
            batchId = UUID.randomUUID().toString();
        }
        if ((xcontext = (XWikiContext)(clonedExecutionContext = this.executionContextCloner.copy(executionContext = this.execution.getContext())).getProperty("xwikicontext")).getWikiId() == null) {
            throw new RuntimeException(String.format("Aborting Mail Sending: the Wiki Id must not be null in the XWiki Context. Got [%s] in the original context.", ((XWikiContext)executionContext.getProperty("xwikicontext")).getWikiId()));
        }
        try {
            this.prepareMailQueueManager.addMessage(new PrepareMailQueueItem(messages, session, listener, batchId, clonedExecutionContext), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.format("Mail prepare queue is still full after waiting [%s] [%s]", new Object[]{60, TimeUnit.SECONDS}), e);
        }
        return new DefaultMailResult(batchId);
    }
}

