/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.internal.configuration.SendMailConfigClassDocumentConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
@Named(value="Mail.MailConfig")
public class MailConfigMandatoryDocumentInitializer
implements MandatoryDocumentInitializer {
    @Inject
    private Logger logger;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public EntityReference getDocumentReference() {
        return SendMailConfigClassDocumentConfigurationSource.MAILCONFIG_REFERENCE;
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        if (this.updateReferences(document)) {
            needsUpdate = true;
        }
        if (!document.isHidden().booleanValue()) {
            document.setHidden(Boolean.valueOf(true));
            needsUpdate = true;
        }
        if (document.getTitle().isEmpty()) {
            document.setTitle("Mail Configuration");
            needsUpdate = true;
        }
        if (this.addGeneralMailConfigClassXObject(document)) {
            needsUpdate = true;
        }
        if (this.addSendMailConfigClassXObject(document)) {
            needsUpdate = true;
        }
        if (this.removeConfigurableClass(document)) {
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean updateReferences(XWikiDocument document) {
        boolean needsUpdate = false;
        if (document.getCreatorReference() == null) {
            document.setCreatorReference(new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), "XWiki", "superadmin"));
            needsUpdate = true;
        }
        if (document.getAuthorReference() == null) {
            document.setAuthorReference(document.getCreatorReference());
            needsUpdate = true;
        }
        if (document.getParentReference() == null) {
            LocalDocumentReference parentReference = new LocalDocumentReference("Mail", "WebHome");
            document.setParentReference((EntityReference)parentReference);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean removeConfigurableClass(XWikiDocument document) {
        boolean needsUpdate = false;
        LocalDocumentReference configurableClassReference = new LocalDocumentReference("XWiki", "ConfigurableClass");
        if (document.getXObject((EntityReference)configurableClassReference) != null) {
            document.removeXObjects((EntityReference)configurableClassReference);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean addGeneralMailConfigClassXObject(XWikiDocument document) {
        LocalDocumentReference generalMailClassReference = new LocalDocumentReference("Mail", "GeneralMailConfigClass");
        return this.addXObject(document, generalMailClassReference, Collections.singletonMap("obfuscateEmailAddresses", "obfuscate"));
    }

    private boolean addSendMailConfigClassXObject(XWikiDocument document) {
        LocalDocumentReference sendMailClassReference = SendMailConfigClassDocumentConfigurationSource.SENDMAILCONFIGCLASS_REFERENCE;
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        fieldMappings.put("admin_email", "from");
        fieldMappings.put("smtp_server", "host");
        fieldMappings.put("smtp_port", "port");
        fieldMappings.put("smtp_server_username", "username");
        fieldMappings.put("smtp_server_password", "password");
        fieldMappings.put("javamail_extra_props", "properties");
        return this.addXObject(document, sendMailClassReference, fieldMappings);
    }

    private boolean addXObject(XWikiDocument document, LocalDocumentReference classReference, Map<String, String> fieldMappings) {
        boolean needsUpdate = false;
        if (document.getXObject((EntityReference)classReference) == null) {
            try {
                XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
                XWiki xwiki = xwikiContext.getWiki();
                BaseObject object = document.newXObject((EntityReference)classReference, xwikiContext);
                for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
                    this.setField(entry.getKey(), entry.getValue(), object, xwiki, xwikiContext);
                }
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error(String.format("Error adding a [%s] object to the document [%s]", classReference.toString(), document.getDocumentReference().toString()));
            }
        }
        return needsUpdate;
    }

    private void setField(String oldPropertyName, String newPropertyName, BaseObject object, XWiki xwiki, XWikiContext xwikiContext) {
        String oldValue = xwiki.getSpacePreference(oldPropertyName, xwikiContext);
        if (!StringUtils.isEmpty((String)oldValue)) {
            object.set(newPropertyName, (Object)oldValue, xwikiContext);
        }
    }
}

