/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory;

import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeMessageFactory;

public abstract class AbstractMessageIterator
implements Iterator<MimeMessage>,
Iterable<MimeMessage> {
    protected MimeMessageFactory<MimeMessage> factory;
    protected int position;
    protected int iteratorSize;
    protected Map<String, Object> parameters;

    protected abstract ExtendedMimeMessage createMessageInternal() throws MessagingException;

    protected abstract Logger getLogger();

    public ExtendedMimeMessage createMessage() throws MessagingException {
        ExtendedMimeMessage message = this.createMessageInternal();
        String type = (String)this.parameters.get("type");
        if (type != null) {
            message.setType(type);
        }
        return message;
    }

    @Override
    public MimeMessage next() {
        ExtendedMimeMessage mimeMessage;
        try {
            mimeMessage = this.createMessage();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to create Mime Message", (Throwable)e);
            mimeMessage = null;
        }
        ++this.position;
        return mimeMessage;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorSize != this.position;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<MimeMessage> iterator() {
        return this;
    }
}

