/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.SessionFactory;
import org.xwiki.mail.script.ScriptMailResult;
import org.xwiki.mail.script.ScriptServicePermissionChecker;
import org.xwiki.script.service.ScriptService;

public abstract class AbstractMailScriptService
implements ScriptService {
    @Inject
    protected MailSender mailSender;
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> componentManagerProvider;
    @Inject
    protected Execution execution;
    @Inject
    protected SessionFactory sessionFactory;
    @Inject
    protected MailSenderConfiguration senderConfiguration;

    protected ScriptMailResult sendAsynchronously(Iterable<? extends MimeMessage> messages, MailListener listener, boolean checkPermissions) {
        if (checkPermissions) {
            try {
                this.checkPermissions();
            }
            catch (MessagingException e) {
                this.setError((Exception)((Object)e));
                return null;
            }
        }
        return new ScriptMailResult(this.mailSender.sendAsynchronously(messages, this.sessionFactory.create(Collections.emptyMap()), listener), listener.getMailStatusResult());
    }

    private void checkPermissions() throws MessagingException {
        ScriptServicePermissionChecker checker;
        String hint = this.senderConfiguration.getScriptServicePermissionCheckerHint();
        try {
            checker = (ScriptServicePermissionChecker)((ComponentManager)this.componentManagerProvider.get()).getInstance(ScriptServicePermissionChecker.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException(String.format("Failed to locate Permission Checker [%s]. The mail has not been sent.", hint), (Exception)((Object)e));
        }
        try {
            checker.check();
        }
        catch (MessagingException e) {
            throw new MessagingException(String.format("Not authorized by the Permission Checker [%s] to send mail! No mail has been sent.", hint), (Exception)((Object)e));
        }
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(this.getErrorKey());
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty(this.getErrorKey(), (Object)e);
    }

    protected abstract String getErrorKey();
}

