/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.script.MimeMessageFactoryProvider;
import org.xwiki.mail.script.AbstractMailScriptService;
import org.xwiki.mail.script.ScriptMailResult;
import org.xwiki.mail.script.ScriptMimeMessage;

@Component
@Named(value="mailsender")
@Singleton
public class MailSenderScriptService
extends AbstractMailScriptService {
    static final String ERROR_KEY = "scriptservice.mailsender.error";

    public ScriptMimeMessage createMessage(String hint, Object source, Map<String, Object> parameters) {
        ScriptMimeMessage result;
        try {
            MimeMessageFactory factory = MimeMessageFactoryProvider.get(hint, MimeMessage.class, (ComponentManager)this.componentManagerProvider.get());
            MimeMessage message = (MimeMessage)factory.createMessage(source, parameters);
            result = new ScriptMimeMessage(message, this.execution, (ComponentManager)this.componentManagerProvider.get());
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        return result;
    }

    public Iterator<MimeMessage> createMessages(String hint, Object source) {
        return this.createMessages(hint, source, Collections.emptyMap());
    }

    public Iterator<MimeMessage> createMessages(String hint, Object source, Map<String, Object> parameters) {
        Iterator result;
        try {
            MimeMessageFactory factory = MimeMessageFactoryProvider.get(hint, (Type)new DefaultParameterizedType(null, Iterator.class, new Type[]{MimeMessage.class}), (ComponentManager)this.componentManagerProvider.get());
            result = (Iterator)factory.createMessage(source, parameters);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        return result;
    }

    public ScriptMimeMessage createMessage(String hint, Object source) {
        return this.createMessage(hint, source, Collections.emptyMap());
    }

    public ScriptMimeMessage createMessage() {
        return this.createMessage(null, null, (String)null);
    }

    public ScriptMimeMessage createMessage(String to, String subject) {
        return this.createMessage(this.senderConfiguration.getFromAddress(), to, subject);
    }

    public ScriptMimeMessage createMessage(String from, String to, String subject) {
        ScriptMimeMessage scriptMessage = new ScriptMimeMessage(this.execution, (ComponentManager)this.componentManagerProvider.get());
        try {
            if (from != null) {
                scriptMessage.setFrom((Address)InternetAddress.parse((String)from)[0]);
            }
            if (to != null) {
                scriptMessage.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            }
            scriptMessage.setSubject(subject);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        return scriptMessage;
    }

    public ScriptMailResult send(MimeMessage message) {
        return this.send(Arrays.asList(message));
    }

    public ScriptMailResult send(Iterable<? extends MimeMessage> messages) {
        return this.send(messages, "memory");
    }

    public ScriptMailResult send(Iterable<? extends MimeMessage> messages, String hint) {
        ScriptMailResult scriptMailResult = this.sendAsynchronously(messages, hint);
        scriptMailResult.getStatusResult().waitTillProcessed(Long.MAX_VALUE);
        return scriptMailResult;
    }

    public ScriptMailResult sendAsynchronously(Iterable<? extends MimeMessage> messages, String hint) {
        MailListener listener;
        try {
            listener = this.getListener(hint);
        }
        catch (MessagingException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
        return this.sendAsynchronously(messages, listener, true);
    }

    private MailListener getListener(String hint) throws MessagingException {
        MailListener listener;
        try {
            listener = (MailListener)((ComponentManager)this.componentManagerProvider.get()).getInstance(MailListener.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException(String.format("Failed to locate [%s] Event listener. ", hint), (Exception)((Object)e));
        }
        return listener;
    }

    public MailSenderConfiguration getConfiguration() {
        return this.senderConfiguration;
    }

    @Override
    protected String getErrorKey() {
        return ERROR_KEY;
    }
}

