/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.mail.MailResultListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.internal.DefaultMailResultListener;
import org.xwiki.mail.internal.MailSenderQueueItem;
import org.xwiki.mail.internal.MailSenderThread;

@Component
@Singleton
public class DefaultMailSender
implements MailSender,
Initializable {
    @Inject
    private MailSenderThread mailSenderThread;
    @Inject
    private MailSenderConfiguration configuration;
    @Inject
    private Logger logger;
    private Queue<MailSenderQueueItem> mailQueue = new ConcurrentLinkedQueue<MailSenderQueueItem>();

    public void initialize() throws InitializationException {
        this.mailSenderThread.setName("Mail Sender Thread");
        this.mailSenderThread.startProcessing(this.getMailQueue());
    }

    public void send(MimeMessage message, Session session) throws MessagingException {
        DefaultMailResultListener listener = new DefaultMailResultListener();
        this.sendAsynchronously(message, session, listener);
        this.waitTillSent(Long.MAX_VALUE);
        BlockingQueue<Exception> errorQueue = listener.getExceptionQueue();
        if (!errorQueue.isEmpty()) {
            throw new MessagingException(String.format("Failed to send mail message [%s]", message), (Exception)errorQueue.peek());
        }
    }

    public void sendAsynchronously(MimeMessage message, Session session, MailResultListener listener) {
        try {
            if (message.getFrom() == null) {
                String from = this.configuration.getFromAddress();
                if (from != null) {
                    message.setFrom((Address)new InternetAddress(from));
                } else {
                    throw new MessagingException("Missing the From Address for sending the mail. You need to either define it in the Mail Configuration or pass it in your message.");
                }
            }
            this.getMailQueue().add(new MailSenderQueueItem(message, session, listener));
        }
        catch (Exception e) {
            listener.onError(message, e);
        }
    }

    public Queue<MailSenderQueueItem> getMailQueue() {
        return this.mailQueue;
    }

    public void waitTillSent(long timeout) {
        long startTime = System.currentTimeMillis();
        while (this.hasMailQueueItemForCurrentThread() && System.currentTimeMillis() - startTime < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for mail to be sent. Reason [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                break;
            }
        }
    }

    private boolean hasMailQueueItemForCurrentThread() {
        for (MailSenderQueueItem item : this.getMailQueue()) {
            if (Thread.currentThread().getId() != item.getThreadId()) continue;
            return true;
        }
        return false;
    }

    public void stopMailSenderThread() throws InterruptedException {
        this.mailSenderThread.stopProcessing();
        this.mailSenderThread.join();
    }
}

