/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.xwiki.mail.MailResultListener;
import org.xwiki.text.XWikiToStringBuilder;

public class MailSenderQueueItem {
    private MimeMessage message;
    private Session session;
    private MailResultListener listener;
    private long threadId;

    public MailSenderQueueItem(MimeMessage message, Session session, MailResultListener listener) {
        this.message = message;
        this.session = session;
        this.listener = listener;
        this.threadId = Thread.currentThread().getId();
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public Session getSession() {
        return this.session;
    }

    public MailResultListener getListener() {
        return this.listener;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String toString() {
        String fromValue;
        String subjectValue;
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        XWikiToStringBuilder messageBuilder = new XWikiToStringBuilder((Object)this);
        try {
            subjectValue = this.getMessage().getSubject();
        }
        catch (Exception e) {
            subjectValue = String.format("<couldn't get message, reason: [%s]>", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        messageBuilder.append("subject", (Object)subjectValue);
        try {
            fromValue = this.getMessage().getFrom()[0].toString();
        }
        catch (Exception e) {
            fromValue = String.format("<couldn't get from, reason: [%s]>", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        messageBuilder.append("from", (Object)fromValue);
        builder.append("message", (Object)(this.getMessage() == null ? null : messageBuilder.toString()));
        builder.append("threadId", this.getThreadId());
        return builder.toString();
    }
}

