/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.template;

import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.internal.AbstractMimeBodyPartFactory;
import org.xwiki.mail.internal.template.AttachmentConverter;
import org.xwiki.mail.internal.template.MailTemplateManager;
import org.xwiki.model.reference.DocumentReference;

public abstract class AbstractTemplateMimeBodyPartFactory
extends AbstractMimeBodyPartFactory<DocumentReference> {
    private static final String ATTACHMENT_PROPERTY_NAME = "attachments";
    private static final String INCLUDE_TEMPLATE_ATTACHMENTS_PROPERTY_NAME = "includeTemplateAttachments";
    @Inject
    @Named(value="text/html")
    private MimeBodyPartFactory<String> htmlBodyPartFactory;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private AttachmentConverter attachmentConverter;

    protected abstract MailTemplateManager getTemplateManager();

    public MimeBodyPart create(DocumentReference documentReference, Map<String, Object> parameters) throws MessagingException {
        Boolean includeTemplateAttachments;
        Map velocityVariables = (Map)parameters.get("velocityVariables");
        String language = (String)parameters.get("language");
        Locale locale = LocaleUtils.toLocale((String)language);
        String textContent = this.getTemplateManager().evaluate(documentReference, "text", velocityVariables, locale);
        String htmlContent = this.getTemplateManager().evaluate(documentReference, "html", velocityVariables, locale);
        HashMap<String, Object> htmlParameters = new HashMap<String, Object>();
        htmlParameters.put("alternate", textContent);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        List parameterAttachments = (List)parameters.get(ATTACHMENT_PROPERTY_NAME);
        if (parameterAttachments != null) {
            attachments.addAll(parameterAttachments);
        }
        if ((includeTemplateAttachments = (Boolean)parameters.get(INCLUDE_TEMPLATE_ATTACHMENTS_PROPERTY_NAME)) != null && includeTemplateAttachments.booleanValue()) {
            try {
                List xwikiAttachments = ((XWikiDocument)this.bridge.getDocument(documentReference)).getAttachmentList();
                attachments.addAll(this.attachmentConverter.convert(xwikiAttachments));
            }
            catch (Exception e) {
                throw new MessagingException(String.format("Failed to include attachments from the Mail Template [%s]", documentReference), e);
            }
        }
        if (!attachments.isEmpty()) {
            htmlParameters.put(ATTACHMENT_PROPERTY_NAME, attachments);
        }
        return this.htmlBodyPartFactory.create((Object)htmlContent, htmlParameters);
    }
}

