/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.template;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.mail.internal.template.MailTemplateManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Singleton
public class DefaultMailTemplateManager
implements MailTemplateManager {
    private static final EntityReference MAIL_CLASS = new EntityReference("Mail", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final String LANGUAGE_PROPERTY_NAME = "language";
    @Inject
    private DocumentAccessBridge documentBridge;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private Execution execution;

    @Override
    public String evaluate(DocumentReference templateReference, String property, Map<String, String> data, Locale locale) throws MessagingException {
        Locale computedLocale = locale;
        if (computedLocale == null || computedLocale == Locale.ROOT) {
            computedLocale = this.getDefaultLocale();
        }
        DocumentReference mailClassReference = this.resolver.resolve((Object)MAIL_CLASS, new Object[0]);
        VelocityContext velocityContext = this.createVelocityContext(data);
        String templateFullName = (String)this.serializer.serialize((EntityReference)templateReference, new Object[0]);
        int objectNumber = this.getObjectMailNumber(templateReference, mailClassReference, computedLocale);
        String content = this.documentBridge.getProperty(templateReference, mailClassReference, objectNumber, property).toString();
        try {
            StringWriter writer = new StringWriter();
            this.velocityManager.getVelocityEngine().evaluate((Context)velocityContext, (Writer)writer, templateFullName, content);
            return writer.toString();
        }
        catch (XWikiVelocityException e) {
            throw new MessagingException(String.format("Failed to evaluate property [%s] for Document [%s] and locale [%s]", property, templateReference, locale), (Exception)((Object)e));
        }
    }

    @Override
    public String evaluate(DocumentReference templateReference, String property, Map<String, String> data) throws MessagingException {
        return this.evaluate(templateReference, property, data, null);
    }

    private int getObjectMailNumber(DocumentReference templateReference, DocumentReference mailClassReference, Locale language) throws MessagingException {
        int number = this.documentBridge.getObjectNumber(templateReference, mailClassReference, LANGUAGE_PROPERTY_NAME, language.getLanguage());
        int mailObjectsCount = this.getMailObjectsCount(templateReference, mailClassReference);
        if (!this.getDefaultLocale().equals(language) && number == -1) {
            number = this.documentBridge.getObjectNumber(templateReference, mailClassReference, LANGUAGE_PROPERTY_NAME, this.getDefaultLocale().getLanguage());
        }
        if (mailObjectsCount == 1 && number == -1) {
            number = 0;
        } else {
            if (mailObjectsCount == 0 && number == -1) {
                throw new MessagingException(String.format("No [%s] object found in the Document [%s] for language [%s]", MAIL_CLASS.toString(), templateReference, language));
            }
            if (number == -1) {
                throw new MessagingException(String.format("No [%s] object matches the locale [%s] or the default locale [%s] in the Document [%s]", MAIL_CLASS.toString(), language, this.getDefaultLocale(), templateReference));
            }
        }
        return number;
    }

    private int getMailObjectsCount(DocumentReference templateReference, DocumentReference mailClassReference) throws MessagingException {
        int objectsCount;
        XWikiContext context = this.getXWikiContext();
        try {
            objectsCount = context.getWiki().getDocument(templateReference, context).getXObjects(mailClassReference).size();
        }
        catch (XWikiException e) {
            throw new MessagingException(String.format("Failed to find number of [%s] objects in Document [%s]", mailClassReference, templateReference), (Exception)((Object)e));
        }
        return objectsCount;
    }

    private VelocityContext createVelocityContext(Map<String, String> data) {
        VelocityContext existingVelocityContext = (VelocityContext)this.getXWikiContext().get((Object)"vcontext");
        VelocityContext velocityContext = existingVelocityContext != null ? new VelocityContext((Context)((VelocityContext)existingVelocityContext.clone())) : new VelocityContext();
        if (data != null) {
            for (Map.Entry<String, String> header : data.entrySet()) {
                velocityContext.put(header.getKey(), (Object)header.getValue());
            }
        }
        return velocityContext;
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private Locale getDefaultLocale() {
        XWikiContext context = this.getXWikiContext();
        return context.getWiki().getDefaultLocale(context);
    }
}

