/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.Execution;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.XWikiAuthenticator;
import org.xwiki.mail.internal.ExtendedMimeMessage;
import org.xwiki.mail.script.MimeMessageWrapper;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="mailsender")
@Singleton
@Unstable
public class MailSenderScriptService
implements ScriptService {
    static final String ERROR_KEY = "scriptservice.mailsender.error";
    @Inject
    private MailSenderConfiguration configuration;
    @Inject
    private MailSender mailSender;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Execution execution;

    public MimeMessageWrapper createMessage(String hint, Object source, Map<String, Object> parameters) {
        MimeMessageWrapper messageWrapper;
        try {
            MimeMessageFactory factory = this.getMimeMessageFactory(hint, source.getClass());
            Session session = this.createSession();
            MimeMessage message = factory.createMessage(session, source, parameters);
            ExtendedMimeMessage extendedMimeMessage = message instanceof ExtendedMimeMessage ? (ExtendedMimeMessage)message : new ExtendedMimeMessage(message);
            messageWrapper = new MimeMessageWrapper(extendedMimeMessage, session, this.mailSender, this.execution, this.configuration, (ComponentManager)this.componentManagerProvider.get());
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        return messageWrapper;
    }

    private MimeMessageFactory getMimeMessageFactory(String hint, Type type) throws ComponentLookupException {
        MimeMessageFactory factory;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        try {
            factory = (MimeMessageFactory)componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeMessageFactory.class, new Type[]{type}), String.format("%s/secure", hint));
        }
        catch (ComponentLookupException e) {
            factory = (MimeMessageFactory)componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeMessageFactory.class, new Type[]{type, null}), hint);
        }
        return factory;
    }

    public MimeMessageWrapper createMessage(String hint, Object source) {
        return this.createMessage(hint, source, Collections.emptyMap());
    }

    public MimeMessageWrapper createMessage() {
        return this.createMessage(null, null, (String)null);
    }

    public MimeMessageWrapper createMessage(String to, String subject) {
        return this.createMessage(this.configuration.getFromAddress(), to, subject);
    }

    public MimeMessageWrapper createMessage(String from, String to, String subject) {
        Session session = this.createSession();
        ExtendedMimeMessage message = new ExtendedMimeMessage(session);
        MimeMessageWrapper messageWrapper = new MimeMessageWrapper(message, session, this.mailSender, this.execution, this.configuration, (ComponentManager)this.componentManagerProvider.get());
        try {
            if (from != null) {
                messageWrapper.setFrom((Address)InternetAddress.parse((String)from)[0]);
            }
            if (to != null) {
                messageWrapper.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            }
            message.setSubject(subject);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        return messageWrapper;
    }

    public MailSenderConfiguration getConfiguration() {
        return this.configuration;
    }

    private Session createSession() {
        Session session = this.configuration.usesAuthentication() ? Session.getInstance((Properties)this.configuration.getAllProperties(), (Authenticator)new XWikiAuthenticator(this.configuration)) : Session.getInstance((Properties)this.configuration.getAllProperties());
        return session;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

