/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.internal.AbstractMailStatusResult;

public class MemoryMailStatusResult
extends AbstractMailStatusResult {
    private Map<String, MailStatus> statusMap = new LinkedHashMap<String, MailStatus>();

    public MailStatus getStatus(String uniqueMessageId) {
        return this.statusMap.get(uniqueMessageId);
    }

    public void setStatus(MailStatus status) {
        this.statusMap.put(status.getMessageId(), status);
    }

    public Iterator<MailStatus> getAll() {
        return this.statusMap.values().iterator();
    }

    public Iterator<MailStatus> getAllErrors() {
        return new AbstractMailStatusIterator(){

            @Override
            boolean match(MailStatus status) {
                return status.getState().endsWith("_error");
            }
        };
    }

    public Iterator<MailStatus> getByState(final MailState state) {
        return new AbstractMailStatusIterator(){

            @Override
            boolean match(MailStatus status) {
                return MailState.parse((String)status.getState()).equals((Object)state);
            }
        };
    }

    private abstract class AbstractMailStatusIterator
    implements Iterator<MailStatus> {
        private final Iterator<MailStatus> it;
        private MailStatus nextStatus;

        private AbstractMailStatusIterator() {
            this.it = MemoryMailStatusResult.this.statusMap.values().iterator();
        }

        abstract boolean match(MailStatus var1);

        @Override
        public boolean hasNext() {
            while (this.nextStatus == null && this.it.hasNext()) {
                this.nextStatus = this.it.next();
                if (this.match(this.nextStatus)) continue;
                this.nextStatus = null;
            }
            return this.nextStatus != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MailStatus next() {
            this.hasNext();
            if (this.nextStatus == null) {
                throw new NoSuchElementException();
            }
            try {
                MailStatus mailStatus = this.nextStatus;
                return mailStatus;
            }
            finally {
                this.nextStatus = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

