/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.mail.internal.UpdateableMailStatusResult;

public abstract class AbstractMailStatusResult
implements UpdateableMailStatusResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailStatusResult.class);
    private long totalSize = -1L;
    private long currentSize;

    @Override
    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public void incrementCurrentSize() {
        ++this.currentSize;
    }

    public long getTotalMailCount() {
        return this.totalSize;
    }

    public long getProcessedMailCount() {
        return this.currentSize;
    }

    public void waitTillProcessed(long timeout) {
        long startTime = System.currentTimeMillis();
        while (!this.isProcessed() && System.currentTimeMillis() - startTime < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for mails to be sent. Reason [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                break;
            }
        }
    }

    public boolean isProcessed() {
        return this.getTotalMailCount() == this.getProcessedMailCount();
    }
}

