/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class AddressConverter
extends AbstractConverter<Address> {
    protected Address convertToType(Type targetType, Object value) {
        InternetAddress address;
        if (value == null) {
            return null;
        }
        try {
            address = InternetAddress.parse((String)value.toString())[0];
        }
        catch (AddressException e) {
            throw new ConversionException(String.format("Failed to convert [%s] to [%s]", value, Address.class.getName()), (Throwable)e);
        }
        return address;
    }

    protected String convertToString(Address value) {
        return InternetAddress.toString((Address[])new Address[]{value});
    }
}

