/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailResult;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.internal.DefaultMailResult;
import org.xwiki.mail.internal.thread.MailQueueManager;
import org.xwiki.mail.internal.thread.MailRunnable;
import org.xwiki.mail.internal.thread.PrepareMailQueueItem;
import org.xwiki.mail.internal.thread.context.Copier;

@Component
@Singleton
public class DefaultMailSender
implements MailSender,
Initializable,
Disposable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private static final String SESSION_BATCHID_KEY = "xwiki.batchId";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="prepare")
    private MailRunnable prepareMailRunnable;
    @Inject
    @Named(value="send")
    private MailRunnable sendMailRunnable;
    @Inject
    private MailQueueManager<PrepareMailQueueItem> prepareMailQueueManager;
    @Inject
    private Copier<ExecutionContext> executionContextCloner;
    private Thread prepareMailThread;
    private Thread sendMailThread;

    public void initialize() throws InitializationException {
        this.prepareMailThread = new Thread(this.prepareMailRunnable);
        this.prepareMailThread.setName("Mail Prepare Thread");
        this.prepareMailThread.setDaemon(true);
        this.prepareMailThread.start();
        this.sendMailThread = new Thread(this.sendMailRunnable);
        this.sendMailThread.setName("Mail Sender Thread");
        this.sendMailThread.setDaemon(true);
        this.sendMailThread.start();
    }

    public MailResult sendAsynchronously(Iterable<? extends MimeMessage> messages, Session session, MailListener listener) {
        ExecutionContext executionContext;
        ExecutionContext clonedExecutionContext;
        XWikiContext xcontext;
        String batchId = session.getProperty(SESSION_BATCHID_KEY);
        if (batchId == null) {
            batchId = UUID.randomUUID().toString();
        }
        if ((xcontext = (XWikiContext)(clonedExecutionContext = this.executionContextCloner.copy(executionContext = this.execution.getContext())).getProperty("xwikicontext")).getWikiId() == null) {
            throw new RuntimeException(String.format("Aborting Mail Sending: the Wiki Id must not be null in the XWiki Context. Got [%s] in the original context.", ((XWikiContext)executionContext.getProperty("xwikicontext")).getWikiId()));
        }
        this.prepareMailQueueManager.addToQueue(new PrepareMailQueueItem(messages, session, listener, batchId, clonedExecutionContext));
        return new DefaultMailResult(batchId);
    }

    public void stopMailThreads() throws InterruptedException {
        this.sendMailRunnable.stopProcessing();
        this.sendMailThread.interrupt();
        this.sendMailThread.join();
        SHUTDOWN_LOGGER.debug(String.format("Mail Prepare Thread has been stopped", new Object[0]));
        this.prepareMailRunnable.stopProcessing();
        this.prepareMailThread.interrupt();
        this.prepareMailThread.join();
        SHUTDOWN_LOGGER.debug(String.format("Mail Sender Thread has been stopped", new Object[0]));
    }

    private MailListener getListener(String hint) throws MessagingException {
        MailListener listener;
        try {
            listener = (MailListener)this.componentManager.getInstance(MailListener.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException(String.format("Failed to locate Mail listener [%s].", hint), (Exception)((Object)e));
        }
        return listener;
    }

    public void dispose() throws ComponentLifecycleException {
        try {
            this.stopMailThreads();
        }
        catch (InterruptedException e) {
            SHUTDOWN_LOGGER.debug("Mail threads shutdown has been interruped", (Throwable)e);
        }
    }
}

