/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Map;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.internal.AbstractMailListener;
import org.xwiki.mail.internal.MemoryMailStatusResult;

@Component
@Named(value="memory")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class MemoryMailListener
extends AbstractMailListener {
    private MemoryMailStatusResult mailStatusResult = new MemoryMailStatusResult();

    @Override
    public void onPrepareMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        super.onPrepareMessageSuccess(message, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.PREPARE_SUCCESS);
        this.mailStatusResult.setStatus(status);
    }

    @Override
    public void onPrepareMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        super.onPrepareMessageError(message, exception, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.PREPARE_ERROR);
        status.setError(exception);
        this.mailStatusResult.setStatus(status);
        this.mailStatusResult.incrementCurrentSize();
    }

    @Override
    public void onPrepareFatalError(Exception exception, Map<String, Object> parameters) {
        super.onPrepareFatalError(exception, parameters);
        this.logger.error("Failure during preparation phase of thread [" + this.getBatchId() + "]");
    }

    @Override
    public void onSendMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        super.onPrepareMessageSuccess(message, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.SEND_SUCCESS);
        this.mailStatusResult.setStatus(status);
        this.mailStatusResult.incrementCurrentSize();
    }

    @Override
    public void onSendMessageFatalError(String uniqueMessageId, Exception exception, Map<String, Object> parameters) {
        super.onSendMessageFatalError(uniqueMessageId, exception, parameters);
        MailStatus status = this.mailStatusResult.getStatus(uniqueMessageId);
        if (status != null) {
            status.setState(MailState.SEND_FATAL_ERROR);
            status.setError(exception);
            this.mailStatusResult.setStatus(status);
        } else {
            this.logger.error("Failed to find a previous mail status for message id [{}] of batch [{}]. Unable to report the fatal error encountered during mail sending.", new Object[]{uniqueMessageId, this.getBatchId(), exception});
        }
        this.mailStatusResult.incrementCurrentSize();
    }

    @Override
    public void onSendMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        super.onSendMessageError(message, exception, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.SEND_ERROR);
        status.setError(exception);
        this.mailStatusResult.setStatus(status);
        this.mailStatusResult.incrementCurrentSize();
    }

    public MailStatusResult getMailStatusResult() {
        return this.mailStatusResult;
    }
}

