/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.internal.factory.AbstractMessageIterator;

public class SerializedFilesMimeMessageIterator
extends AbstractMessageIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializedFilesMimeMessageIterator.class);
    private static final String ROOT_DIRECTORY = "mailstore";
    private final File[] files;
    private ComponentManager componentManager;
    private Environment environment;
    private File batchDirectory;

    public SerializedFilesMimeMessageIterator(String batchId, Map<String, Object> parameters, ComponentManager componentManager) throws MessagingException {
        this.componentManager = componentManager;
        try {
            this.environment = (Environment)this.componentManager.getInstance(Environment.class);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException("Failed to find an Environment Component", (Exception)((Object)e));
        }
        this.batchDirectory = new File(new File(this.environment.getPermanentDirectory(), ROOT_DIRECTORY), batchId);
        this.files = this.batchDirectory.listFiles();
        this.iteratorSize = this.files.length;
        this.parameters = parameters;
    }

    @Override
    protected ExtendedMimeMessage createMessageInternal() throws MessagingException {
        File file = this.files[this.position];
        try {
            FileInputStream emailStream = new FileInputStream(file);
            return new ExtendedMimeMessage(null, (InputStream)emailStream);
        }
        catch (FileNotFoundException e) {
            throw new MessagingException(String.format("Failed to create mime message from file [%s]", file.getPath()), (Exception)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

