/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.usersandgroups;

import com.xpn.xwiki.internal.plugin.rightsmanager.UserDataExtractor;
import com.xpn.xwiki.internal.plugin.rightsmanager.UserIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Address;
import org.xwiki.context.Execution;
import org.xwiki.mail.internal.factory.usersandgroups.AddressUserDataExtractor;
import org.xwiki.mail.internal.factory.usersandgroups.UsersAndGroupsSource;
import org.xwiki.model.reference.DocumentReferenceResolver;

public class AddressUserIterator
extends UserIterator<Address> {
    private UsersAndGroupsSource usersAndGroupsSource;
    private Iterator<Address> addressIterator;
    private List<Address> excludedAddresses;
    private List<Address> processedAddresses = new ArrayList<Address>();
    private Address lookaheadAddress;

    public AddressUserIterator(UsersAndGroupsSource usersAndGroupsSource, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, Execution execution) {
        super(usersAndGroupsSource.getIncludedUserAndGroupReferences(), usersAndGroupsSource.getExcludedUserAndGroupReferences(), (UserDataExtractor)new AddressUserDataExtractor(), explicitDocumentReferenceResolver, execution);
        this.addressIterator = usersAndGroupsSource.getIncludedAddresses().iterator();
        this.excludedAddresses = usersAndGroupsSource.getExcludedAddresses();
        this.usersAndGroupsSource = usersAndGroupsSource;
    }

    public boolean hasNext() {
        if (this.lookaheadAddress == null) {
            this.lookaheadAddress = this.getNext();
        }
        return this.lookaheadAddress != null;
    }

    public Address next() {
        Address address = this.lookaheadAddress;
        if (address != null) {
            this.lookaheadAddress = null;
        } else {
            address = this.getNext();
            if (address == null) {
                throw new NoSuchElementException(String.format("No more addresses to extract from [%s]", this.usersAndGroupsSource));
            }
        }
        return address;
    }

    private Address getNext() {
        Address address;
        do {
            if (super.hasNext()) {
                address = (Address)super.next();
                continue;
            }
            if (this.addressIterator.hasNext()) {
                address = this.addressIterator.next();
                continue;
            }
            return null;
        } while (this.excludedAddresses.contains(address) || this.processedAddresses.contains(address));
        this.processedAddresses.add(address);
        return address;
    }
}

